<?php
/**
* Open-Realty
* 
* Open-Realty is free software; you can redistribute it and/or modify
* it under the terms of the Open-Realty License as published by	
* Transparent Technologies; either version 1 of the License, or
* (at your option) any later version.
* 
* Open-Realty is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	
* Open-Realty License for more details.	
* http://www.open-realty.org/license_info.html
* 
* You should have received a copy of the Open-Realty License
* along with Open-Realty; if not, write to Transparent Technologies	
* RR1 Box 162C, Kingsley, PA  18826  USA
* 
* @author Ryan C. Bonham <ryan@transparent-tech.com> 
* @copyright Transparent Technologies 2004
* @link http://www.open-realty.org Open-Realty Project
* @link http://www.transparent-tech.com Transparent Technologies
* @link http://www.open-realty.org/license_info.html Open-Realty License
*/


/**
 * install_addon()
 * This function should create and update any necessary database tables.
 * Developers can store version information for the addon in the addons table, 
 * and use it to determine if an install or upgrade is needed.
 * @return 
 **/
function youtube_install_addon()
{
	$current_version = "1";
	global $conn, $config;
	require_once($config['basepath'].'/include/misc.inc.php');
	$misc = new Misc();
	//Check Current Installed Version
	$sql = 'SELECT addons_version FROM '.$config['table_prefix_no_lang'].'addons WHERE addons_name = \'youtube\'';
	$recordSet = $conn->Execute($sql);
	$version = $recordSet->fields[0];
	if ($version == '') 
	{
		// Preform a new install. Create any needed databases etc, and insert version number into addon table.
		$sql_insert[] = "INSERT INTO " . $config['table_prefix'] . "listingsformelements VALUES (DEFAULT,'url','addon_youtube','YouTube URL','','',20,0,8,'No','','No',0,NULL,NULL,0,0)";
		$sql_insert[] = 'INSERT INTO '.$config['table_prefix_no_lang'].'addons (addons_version, addons_name) VALUES (\'1\',\'youtube\')';
		$sql_insert[] = "CREATE TABLE ".$config['table_prefix_no_lang']."addons_youtube (
				addons_youtube_id INT(5) NOT NULL AUTO_INCREMENT,
				addons_youtube_usepopup INT(2) NOT NULL,
				addons_youtube_popupwidth INT(4) NOT NULL,
				addons_youtube_popupheight INT(4) NOT NULL,
				addons_youtube_embeddedwidth INT(4) NOT NULL,
				addons_youtube_embeddedheight INT(4) NOT NULL,
				PRIMARY KEY(addons_youtube_id)
				)";
		$sql_insert[] = "INSERT INTO ".$config['table_prefix_no_lang']."addons_youtube VALUES ('1', '0', '475', '650', '425','350')";
		while (list($elementindexvalue, $elementcontents) = each($sql_insert))
		{
			$recordSet = $conn->Execute($elementcontents);
			if ($recordSet === false) die ("<b><font color=red>ERROR - $elementcontents</font></b>");
		}
                //$recordSet = $conn->Execute($sql);
		return TRUE; 
	}
	elseif ($version != $current_version)
	{
	    //Preform Updates to database based on previous installed version.
		switch($version)
		{
	    	case '0';
                break;
	    } // switch
		return TRUE;
	}
	return FALSE;
}
/**
 * show_admin_icons()
 * This function should return an array of the html links that should be shown on the administrative page.
 * @return array should return each link that shoudl be shown in the admin section. Should return a string if it is a single link, or an array for multiple links.
 **/
function youtube_show_admin_icons()
{
	$admin_link = '<a href="index.php?action=addon_youtube_admin">URL YouTube Addon Config</a>';
	return $admin_link;
} 
/**
 * load_template()
 *  This should return an array with all the template tags for open-realty's template engine to parse
 * @return array List of template_fields
 **/
function youtube_load_template()
{
	$template_array = array('addon_youtube_link');
	return $template_array;
} 
/**
 * run_action_user_template()
 * This function handles user $_GET[] actions related to the addon. Function must be named using this method: addon_addonname_description.
 * @return string Should return all contents that should be displayed when an addon specific $_GET['action'] is called.
 **/
function youtube_run_action_user_template()
{/*
	switch ($_GET['action']) {
		case 'addon_youtube_showpage1':
			$data = youtube_display_addon_page();
			break;
		default:
			$data = '';
			break;
	} // End switch ($_GET['action'])
	return $data;*/
} 
/**
 * run_action_admin_template()
 * This function handles administrative $_GET[] actions related to the addon. Function must be named using this method: addon_addonname_description.
 * @return string Should return all contents that should be displayed when a addon specific $_GET['action'] is called.
 **/
function youtube_run_action_admin_template()
{
	switch ($_GET['action']) {
		case 'addon_youtube_admin':
			$data = youtube_display_admin_page();
			break;
		default:
			$data = '';
			break;
	} // End switch ($_GET['action'])
	return $data;
} 
/**
 * run_template_user_fields()
 * This function handles all the replacement of {template_tags} with the actual content. All tags setup here must also be added to the load_template function in order for open-realty to parse them.
 * @param string $tag
 * @return string Should return all contents that should be displayed when a addon specific $tag is called.
 **/
function youtube_run_template_user_fields($tag = '')
{
	switch ($tag) {
		case 'addon_youtube_link':
			$data = youtube_display_addon_link($_GET['listingID']);
			break;
		default:
			$data = '';
			break;
	} // End switch ($_GET['action'])
	return $data;
} 
// Addon Specific Function

function youtube_display_addon_link($listingID)
{
		global $config,$lang,$conn,$current_ID;
		require_once($config['basepath'].'/include/misc.inc.php');
		$misc = new misc();
		$field = "addon_youtube";
		$sql = "SELECT * FROM ".$config["table_prefix_no_lang"]."addons_youtube";
		$recordSet = $conn->Execute($sql);
		if (!$recordSet)
			{
				echo "ERROR: ".$sql;
			}
		$usepopup = $recordSet->fields["addons_youtube_usepopup"];
		$popupwidth = $recordSet->fields["addons_youtube_popupwidth"];
		$popupheight = $recordSet->fields["addons_youtube_popupheight"];
		$embeddedwidth = $recordSet->fields["addons_youtube_embeddedwidth"];
		$embeddedheight = $recordSet->fields["addons_youtube_embeddedheight"];
		$display = '';
		$name = $misc->make_db_extra_safe($field);
//Get the listing ID
			if ($current_ID != '')
				{
				$_GET['listingID'] = $current_ID;
				}
			if (isset($_GET['listingID']))
			{
				$listingID = $_GET['listingID'];
				$sql = "SELECT listingsdbelements_field_value FROM " . $config['table_prefix'] . "listingsdbelements, " . $config['table_prefix'] . "listingsformelements WHERE ((" . $config['table_prefix'] . "listingsdbelements.listingsdb_id = $listingID) AND (listingsformelements_field_name = listingsdbelements_field_name) AND (listingsdbelements_field_name = $name))";
				$recordSet = $conn->Execute($sql);
					if ($recordSet === false)
					{
					$misc->log_error($sql);
					}
					while (!$recordSet->EOF)
					{
					$field_value = $misc->make_db_unsafe ($recordSet->fields['listingsdbelements_field_value']);
			if ($field_value != '')
				{
					//I must extract the YouTube ID from the URL example lEe3G_Z0B7Y in http://www.youtube.com/watch?v=lEe3G_Z0B7Y
					$youtubeID = substr($field_value,-11);
					if(file_exists($config['template_path'].'/images/'.$image))
					{
						if($usepopup == '1')
						{
							$display = '<a class="highlite_red" href="'.$config["baseurl"]."/addons/youtube/youtube.php?youtubeid=".$youtubeID.'&amp;embeddedwidth='.$embeddedwidth.'&amp;embeddedheight='.$embeddedheight.'" onclick="window.open(\''.$config["baseurl"]."/addons/youtube/youtube.php?youtubeid=".$youtubeID.'&amp;embeddedwidth='.$embeddedwidth.'&amp;embeddedheight='.$embeddedheight.'\',\'\',\'width='.$popupwidth.',height='.$popupheight.'\');return false;"><img src="'.$config['template_url'].'/images/'.$image.'" alt="Click here for OnLine Video" /></a>';
						}
						else
						{
							$display = '
							            <object width="'.$embeddedwidth.'" height="'.$embeddedheight.'">
                                      <param name="movie" value="http://www.youtube.com/v/'.$youtubeID.'"></param>
                                      <param name="wmode" value="transparent"></param>
                                      <embed src="http://www.youtube.com/v/'.$youtubeID.'" 
                                        type="application/x-shockwave-flash" 
                                        wmode="transparent" width="'.$embeddedwidth.'" height="'.$embeddedheight.'">
                                      </embed>
                                    </object>'; 
						}
					}
					else
					{
						if($usepopup == '1')
						{
							$display = '<a class="highlite_red" href="'.$config["baseurl"]."/addons/youtube/youtube.php?youtubeid=".$youtubeID.'&amp;embeddedwidth='.$embeddedwidth.'&amp;embeddedheight='.$embeddedheight.'" onclick="window.open(\''.$config["baseurl"]."/addons/youtube/youtube.php?youtubeid=".$youtubeID.'&amp;embeddedwidth='.$embeddedwidth.'&amp;embeddedheight='.$embeddedheight.'\',\'\',\'width='.$popupwidth.',height='.$popupheight.'\');return false;">Click here for OnLine Video</a>';
						}
						else
						{
							$display = '
							            <object width="'.$embeddedwidth.'" height="'.$embeddedheight.'">
                                      <param name="movie" value="http://www.youtube.com/v/'.$youtubeID.'"></param>
                                      <param name="wmode" value="transparent"></param>
                                      <embed src="http://www.youtube.com/v/'.$youtubeID.'" 
                                        type="application/x-shockwave-flash" 
                                        wmode="transparent" width="'.$embeddedwidth.'" height="'.$embeddedheight.'">
                                      </embed>
                                    </object>'; 
						}
					}
				}
					$recordSet->MoveNext();
					}
			}
	return $display;
} 
// Addon Specific Function
function youtube_display_addon_page()
{/*
	$display = 'This is a Addon page';
	return $display;*/
} 
// Addon Specific Function
function youtube_display_admin_page()
{/*
	$display = 'This is a Addon admin page';
	return $display;*/
				global $conn, $lang, $config;
				require_once('../include/misc.inc.php');
				$misc = new misc();
				$security = login::loginCheck('Admin',TRUE);
				$display = '';

				//Generate GuideString
				$guidestring = '';
				foreach ($_GET as $k => $v)
				{
					if (is_array($v))
					{
						foreach ($v as $vitem)
						{
							$guidestring .= '&amp;' . urlencode("$k") . '[]=' . urlencode("$vitem");
						}
					}
					else
					{
						$guidestring .= '&amp;' . urlencode("$k") . '=' . urlencode("$v");
					}
	
				}
				//Save any Post Data
				if (isset($_POST['addons_youtube_usepopup']))
				{
					//Update ControlPanel
					$sql = 'UPDATE '.$config['table_prefix_no_lang'].'addons_youtube SET ';
					$sql_part = '';
					foreach($_POST as $field => $value)
					{
						if (is_array($value)) 
						{
						    $value2 = '';
							foreach ($value as $f)
							{
								if ($value2 == '')
								{
									$value2 = "$f";
								}
								else
								{
									$value2 .= ",$f";
								}
							}
							if ($sql_part == '')
							{
								$sql_part = "$field = '$value2'";
							}
							else
							{
								$sql_part .= " , $field = '$value2'";
							}
						}
						else
						{
							$value = $misc->make_db_safe($value);
							if ($sql_part == '')
							{
								
								$sql_part = "$field = $value";
							}
							else
							{
								$sql_part .= " , $field = $value";
							}
						}
					}
					$sql .= $sql_part;
					$recordSet = $conn->Execute($sql);
					if (!$recordSet)
					{
						$misc->log_error($sql);
					}
					$display .= '<br><b>'.$lang['configuration_saved'].'</b><br>';
				}

				$sql = 'SELECT * from '.$config["table_prefix_no_lang"].'addons_youtube';
				$recordSet = $conn->Execute($sql);
				if (!$recordSet)
				{
					$misc->log_error($sql);
				}
				// Include the Form Generation Class
				include('../include/class/form_generation.inc.php');
				//Default Options
				$yes_no[0] = 'No';
				$yes_no[1] = 'Yes';
				$number_format[1] = '1,000.00';
				$number_format[2] = '1.000,00';
				$number_format[3] = '1 000.00';
				$number_format[4] = '1 000,00';
				$number_format[5] = '1\'000,00';
				$number_format[6] = '1-000 00';
				$formGen = new formGeneration();
				$display .= '<h2>Addon YouTube Configurator</h2><a href="&#109;&#97;&#105;&#108;&#116;&#111;&#58;&#119;&#101;&#98;&#109;&#97;&#115;&#116;&#101;&#114;&#64;&#100;&#114;&#108;&#105;&#115;&#116;&#105;&#110;&#103;&#115;&#46;&#99;&#111;&#109;">
				             Paul Lacourse</a> from <a href="http://www.enparadise.com/" target="_blank">En Paradise</a><br /><br />';
				$display .= $formGen->startform('index.php?'.$guidestring);
				$display .= '<fieldset>';

				$display .= '<table cellspacing="0" cellpadding="3" width="99%" border="0">';

				$display .= '<tr class=tdshade1>';
				$display .= '<td width="130"><strong>Small YouTube Popup?</strong></td>';

				$display .= '<td>'.$formGen->createformitem('select','addons_youtube_usepopup',misc::make_db_unsafe($recordSet->fields['addons_youtube_usepopup']),FALSE,35,'','','','',$yes_no,misc::make_db_unsafe($recordSet->fields['addons_youtube_usepopup'])).'</td>';
				$display .= '<td>Would you like to have YouTube Video in a specified size popup (Yes) or embedded in the detail page (no)?</td>';
				$display .= '</tr>';

				$display .= '<tr class=tdshade2>';
				$display .= '<td width="100"><strong>Popup Width:</strong></td>';
				$display .= '<td>'.$formGen->createformitem('text','addons_youtube_popupwidth',misc::make_db_unsafe($recordSet->fields['addons_youtube_popupwidth']),FALSE,3,'','','','',$number_format,misc::make_db_unsafe($recordSet->fields['addons_youtube_popupwidth'])).'</td>';
				$display .= '<td>If using small popup window, the Width of your popup.</td>';
				$display .= '</tr>';

				$display .= '<tr class=tdshade1>';
				$display .= '<td width="100"><strong>Popup Height:</strong></td>';
				$display .= '<td>'.$formGen->createformitem('text','addons_youtube_popupheight',misc::make_db_unsafe($recordSet->fields['addons_youtube_popupheight']),FALSE,3,'','','','',$number_format,misc::make_db_unsafe($recordSet->fields['addons_youtube_popupheight'])).'</td>';
				$display .= '<td>If using small popup window, the Height of your popup.</td>';
				$display .= '</tr>';

				$display .= '<tr class=tdshade2>';
				$display .= '<td width="100"><strong>Embedded Width:</strong></td>';
				$display .= '<td>'.$formGen->createformitem('text','addons_youtube_popupwidth',misc::make_db_unsafe($recordSet->fields['addons_youtube_embeddedwidth']),FALSE,3,'','','','',$number_format,misc::make_db_unsafe($recordSet->fields['addons_youtube_popupwidth'])).'</td>';
				$display .= '<td>The Control Width of your Video. Normaly the default value should be ok unless YouTube.com decide to change their video format.</td>';
				$display .= '</tr>';

				$display .= '<tr class=tdshade1>';
				$display .= '<td width="100"><strong>Embedded Height:</strong></td>';
				$display .= '<td>'.$formGen->createformitem('text','addons_youtube_popupheight',misc::make_db_unsafe($recordSet->fields['addons_youtube_embeddedheight']),FALSE,3,'','','','',$number_format,misc::make_db_unsafe($recordSet->fields['addons_youtube_popupheight'])).'</td>';
				$display .= '<td>The Control Height of your Video. Normaly the default value should be ok unless YouTube.com decide to change their video format.</td>';
				$display .= '</tr>';

				$display .= '</table>';
				$display .= '<table width="99%" align="right"><tr><td align="right">'.$formGen->createformitem('submit','','Save Changes').'</td></tr></table>';
				$display .= $formGen->endform();
	return $display;
} 

?>

